//------------------VECTOR.CPP--------------
#include <math.h>
#include "vector1.hpp"
#include "types.h" //for SMALL_REAL
#include "random.h" //for Randomunitpair in Randomunitvector
//----TWO DIMENSIONAL STUFF-----------------------------------------
//------------------Vector2 methods-------------------
Vector2 Vector2::operator/=(Real f)
{
	if (fabs(f) >= SMALL_REAL)
     {
     	_x/=f;
          _y/=f;
     }
     return *this;
}

Real Vector2::Magnitude() const
{
	return sqrt(_x*_x + _y*_y);
}

Vector2 Vector2::Normalize()
{ //Make the Vector2 a unit Vector2, and return it
	Real m = Magnitude();
	if (m < SMALL_REAL)
	{
		_x = 1.0;
		_y = 0;
	}
	else
	{
		_x /= m;
		_y /= m;
	}
	return *this;
}

Real Vector2::MagnitudeNormalize()
{ //Make the Vector2 a unit Vector2, and return its old magnitude
	Real m = Magnitude();
	if (m < SMALL_REAL)
	{
		_x = 1.0;
		_y = 0;
	}
	else
	{
		_x /= m;
		_y /= m;
	}
	return m;
}


Vector2 Vector2::Rotate(Real angle)
{  //Rotate angle radians counterclockwise.
	Real temp_x =_x*cos(angle) - _y*sin(angle);
	_y = _x*sin(angle) + _y*cos(angle);
	_x = temp_x;
	return *this;
}

//--------------Friend functions for Vector2-------------

Vector2 operator*(const Vector2 &u, Real f) //Scalar prod
{
	return Vector2(u._x * f,	u._y * f);
}

Vector2 operator*(Real f, const Vector2 &u) //Scalar prod
{
	return Vector2(u._x * f, u._y * f);
}

Vector2 operator+(const Vector2 &u, const Vector2 &v)
{
	return Vector2(u._x + v._x, u._y + v._y);
}

Vector2 operator-(const Vector2 &u, const Vector2 &v)
{
	return Vector2(u._x - v._x, u._y - v._y);
}

Real operator%(const Vector2 &u, const Vector2 &v)
{
	return (u._x*v._x + u._y*v._y);
}



